/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.coordinator;

import filenet.vw.apps.coordinator.VWCoordinatorApplet;
import filenet.vw.base.VWDebug;
import java.awt.BorderLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class VWHttpCoordinatorApplet
extends VWCoordinatorApplet
implements HyperlinkListener {
    public void init() {
        try {
            super.init();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.getHTMLPane(), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        try {
            if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String eventURL = event.getURL().toString();
                if (eventURL == null) {
                    return;
                }
                int nIndex = eventURL.lastIndexOf(47);
                if (nIndex != -1) {
                    eventURL = eventURL.substring(nIndex + 1, eventURL.length());
                }
                if (eventURL.equalsIgnoreCase("admin")) {
                    this.doShowAdminApplication();
                } else if (eventURL.equalsIgnoreCase("config")) {
                    this.doShowConfigApplication();
                } else if (eventURL.equalsIgnoreCase("designer")) {
                    this.doShowDesignerApplication(null, null, null);
                } else if (eventURL.equalsIgnoreCase("manager")) {
                    this.doShowManagerApplication();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private JEditorPane getHTMLPane() {
        URL pageURL = null;
        JEditorPane pane = null;
        try {
            pageURL = new URL(this.getCodeBase(), this.m_sessionInfo.getProperty("displayPage"));
            pane = new JEditorPane(pageURL);
            pane.setEditable(false);
            pane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            pane.addHyperlinkListener(this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return pane;
    }
}

